package com.ejie.ab04b.service;

import java.util.List;

import com.ejie.ab04b.exception.AB04BException;
import com.ejie.ab04b.model.DocumentoOS3;
import com.ejie.foldermanagement.xml.DocumentEvent;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab0497s00Service generated by UDA, 05-Apr-2017 09:34:34.
 * 
 * @author UDA
 */

public interface DocumentoOS3Service {

	/**
	 * Inserts a single row in the Ab0497s00 table.
	 * 
	 * ab0497s00 Ab0497s00 Ab0497s00
	 * 
	 * @param ab0497s00
	 *            the ab 0497 s 00
	 * @return the documento OS 3
	 */
	DocumentoOS3 add(DocumentoOS3 ab0497s00);

	/**
	 * Inserts a single row in the Ab0497s00 table.
	 * 
	 * ab0497s00 Ab0497s00 temp boolean Ab0497s00
	 * 
	 * @param ab0497s00
	 *            the ab 0497 s 00
	 * @param temp
	 *            the temp
	 * @return the documento os3
	 */
	DocumentoOS3 add(DocumentoOS3 ab0497s00, boolean temp);

	/**
	 * Inserts a single row in the ab0494s00 table.
	 * 
	 * documents List<DocumentEvent> fechaCreacion String idTramite Long
	 * 
	 * @param documents
	 *            the documents
	 * @param fechaCreacion
	 *            the fecha creacion
	 * @param idTramite
	 *            the id tramite
	 */
	public void addDocumentosSolicitud(List<DocumentEvent> documents,
			String fechaCreacion, Long idTramite);

	/**
	 * Updates a single row in the Ab0497s00 table.
	 * 
	 * ab0497s00 Ab0497s00 Ab0497s00
	 * 
	 * @param ab0497s00
	 *            the ab 0497 s 00
	 * @return the documento OS 3
	 */
	DocumentoOS3 update(DocumentoOS3 ab0497s00);

	/**
	 * Sube fichero PIF.
	 * 
	 * datosFichero byte[] rutaFichero String nombreFichero String preservaName
	 * boolean DocumentoOs3
	 * 
	 * @param datosFichero
	 *            the datos fichero
	 * @param rutaFichero
	 *            the ruta fichero
	 * @param nombreFichero
	 *            the nombre fichero
	 * @param preservaName
	 *            the preserva name
	 * @return the documento os3
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */
	public DocumentoOS3 subeFicheroPIF(byte[] datosFichero, String rutaFichero,
			String nombreFichero, boolean preservaName) throws AB04BException;

	/**
	 * Updates a single row in the Ab0494s00 table.
	 * 
	 * documento DocumentoOS3 Ab0497s00
	 * 
	 * @param documento
	 *            the documento
	 * @return the documento OS 3
	 */
	DocumentoOS3 updateFilled(DocumentoOS3 documento);

	/**
	 * Finds a single row in the Ab0497s00 table.
	 * 
	 * ab0497s00 Ab0497s00 Ab0497s00
	 * 
	 * @param ab0497s00
	 *            the ab 0497 s 00
	 * @return the documento OS 3
	 */
	DocumentoOS3 find(DocumentoOS3 ab0497s00);

	/**
	 * Finds a single row in the Ab0497s00 table.
	 * 
	 * oid String Ab0497s00
	 * 
	 * @param oid
	 *            the oid
	 * @return the documento OS 3
	 */
	DocumentoOS3 findByOid(String oid);

	/**
	 * Finds a single row in the Ab0497s00 table.
	 * 
	 * ab0497s00 Ab0497s00 Ab0497s00
	 * 
	 * @param ab0497s00
	 *            the ab 097 s 00
	 * @return the documento os3
	 */
	public DocumentoOS3 findTemp(DocumentoOS3 ab0497s00);

	/**
	 * Deletes a single row in the Ab0497s00 table.
	 * 
	 * ab0497s00 Ab0497s00
	 * 
	 * @param ab0497s00
	 *            the ab 0497 s 00
	 */
	void remove(DocumentoOS3 ab0497s00);

	/**
	 * Deletes a single row in the Ab0427s00 table.
	 * 
	 * ab0429s00 Ab0429s00
	 * 
	 * @param ab0429s00
	 *            the ab 0429 s 00
	 */
	void removeTemp(DocumentoOS3 ab0429s00);

	/**
	 * Deletes a single row in the Ab0429s00 table.
	 * 
	 * ab0429s00 Ab0429s00
	 * 
	 * @param ab0429s00
	 *            the ab 0429 s 00
	 */
	void removeTempByApertura(DocumentoOS3 ab0429s00);

	/**
	 * Finds a list of rows in the Ab0497s00 table.
	 * 
	 * ab0497s00 Ab0497s00 jqGridRequestDto JQGridRequestDto List<Ab0497s00>
	 * 
	 * @param ab0497s00
	 *            the ab 0497 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	List<DocumentoOS3> findAll(DocumentoOS3 ab0497s00,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Finds rows in the Ab0497s00 table using like.
	 * 
	 * ab0497s00 Ab0497s00 jqGridRequestDto JQGridRequestDto startsWith Boolean
	 * List<Ab0497s00>
	 * 
	 * @param ab0497s00
	 *            the ab 0497 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	List<DocumentoOS3> findAllLike(DocumentoOS3 ab0497s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter method in the Ab0497s00 table.
	 * 
	 * filterAb0497s00 Ab0497s00 jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean JQGridResponseDto<Ab0497s00>
	 * 
	 * @param filterAb0497s00
	 *            the filter ab 0497 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the JQ grid response dto
	 */
	JQGridResponseDto<DocumentoOS3> filter(DocumentoOS3 filterAb0497s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Searches rows in the Ab0497s00 table.
	 * 
	 * filterAb0497s00 Ab0497s00 searchAb0497s00 Ab0497s00 jqGridRequestDto
	 * JQGridRequestDto startsWith Boolean List<TableRowDto<Ab0497s00>>
	 * 
	 * @param filterAb0497s00
	 *            the filter ab 0497 s 00
	 * @param searchAb0497s00
	 *            the search ab 0497 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	List<TableRowDto<DocumentoOS3>> search(DocumentoOS3 filterAb0497s00,
			DocumentoOS3 searchAb0497s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/**
	 * Reorder the selection made in Ab0497s00 table.
	 * 
	 * filterAb0497s00 Ab0497s00 jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean Object
	 * 
	 * @param filterAb0497s00
	 *            the filter ab 0497 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the object
	 */
	Object reorderSelection(DocumentoOS3 filterAb0497s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Find by tramite.
	 * 
	 * doc the doc the documento OS 3
	 * 
	 * @param doc
	 *            the doc
	 * @return the documento OS 3
	 */
	DocumentoOS3 findByTramite(DocumentoOS3 doc);

	/**
	 * Descargar documento.
	 * 
	 * rutaCompletaFichero String byte[]
	 * 
	 * @param rutaCompletaFichero
	 *            the ruta completa fichero
	 * @return the byte[]
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */
	byte[] descargarDocumento(String rutaCompletaFichero) throws AB04BException;
}
